/*
 * Decompiled with CFR 0.152.
 */
package mathgeo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Vitesse
extends JDialog {
    private Object combo;
    private int rang_sortie;
    private int rang_entrer;
    private double resultat;
    private String str;
    private final JLabel egale;
    private JComboBox combo_entrer;
    private final JTextField entrer;
    private JPanel jPanel1;
    private JComboBox combo_sortie;
    private final JTextField sortie;
    private final JLabel labimage;
    private final ImageIcon vitesseico;

    public Vitesse(JFrame proprio) {
        super(proprio, "Vitesse", false);
        this.setSize(923, 235);
        JPanel pan = new JPanel();
        pan.setBackground(new Color(215, 200, 170));
        this.setContentPane(pan);
        this.vitesseico = new ImageIcon(this.getClass().getResource("speed.png"));
        this.labimage = new JLabel(this.vitesseico);
        this.entrer = new JTextField(16);
        this.combo_entrer = new JComboBox();
        this.egale = new JLabel("=");
        this.sortie = new JTextField(16);
        this.combo_sortie = new JComboBox();
        Container contenu = this.getContentPane();
        contenu.setLayout(new FlowLayout());
        contenu.add(this.labimage);
        contenu.add(this.entrer);
        contenu.add(this.combo_entrer);
        contenu.add(this.egale);
        contenu.add(this.sortie);
        contenu.add(this.combo_sortie);
        this.combo_entrer.setPreferredSize(new Dimension(180, 20));
        this.combo_sortie.setPreferredSize(new Dimension(180, 20));
        this.combo_entrer.addItem("km/s");
        this.combo_entrer.addItem("m/s");
        this.combo_entrer.addItem("km/h");
        this.combo_entrer.addItem("Millim\u00e8tres par seconde");
        this.combo_entrer.addItem("Microm\u00e8tres par seconde");
        this.combo_sortie.addItem("km/s");
        this.combo_sortie.addItem("m/s");
        this.combo_sortie.addItem("km/h");
        this.combo_sortie.addItem("Millim\u00e8tres par seconde");
        this.combo_sortie.addItem("Microm\u00e8tres par seconde");
        this.combo_entrer.addActionListener(e -> {
            this.rang_entrer = this.combo_entrer.getSelectedIndex();
            this.affichage();
        });
        this.combo_sortie.addActionListener(e -> {
            this.rang_sortie = this.combo_sortie.getSelectedIndex();
            this.affichage();
        });
    }

    private void affichage() {
        boolean estpositif = true;
        try {
            double valeur = Double.parseDouble(this.entrer.getText());
            if (valeur <= 0.0) {
                this.entrer.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
                this.entrer.setBackground(new Color(255, 255, 255));
                this.entrer.requestFocus();
                estpositif = false;
            }
            if (estpositif) {
                NumberFormat Myformat = NumberFormat.getInstance();
                Myformat.setMinimumFractionDigits(9);
                Myformat.setMaximumFractionDigits(9);
                if (this.rang_entrer == 0 && this.rang_sortie == 0) {
                    this.resultat = valeur * 1.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 0 && this.rang_sortie == 1) {
                    this.resultat = valeur * 1000.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 0 && this.rang_sortie == 2) {
                    this.resultat = valeur * 3600.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 0 && this.rang_sortie == 3) {
                    this.resultat = valeur * 1000000.0;
                    DecimalFormat MyformatE = new DecimalFormat("0.000000E0");
                    this.str = MyformatE.format(this.resultat);
                } else if (this.rang_entrer == 0 && this.rang_sortie == 4) {
                    this.resultat = valeur * 1.0E9;
                    DecimalFormat MyformatE = new DecimalFormat("0.000000E0");
                    this.str = MyformatE.format(this.resultat);
                } else if (this.rang_entrer == 1 && this.rang_sortie == 0) {
                    this.resultat = valeur * 0.001;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 1 && this.rang_sortie == 1) {
                    this.resultat = valeur * 1.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 1 && this.rang_sortie == 2) {
                    this.resultat = valeur * 3.6;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 1 && this.rang_sortie == 3) {
                    this.resultat = valeur * 1000.0;
                    DecimalFormat MyformatE = new DecimalFormat("0.000000E0");
                    this.str = MyformatE.format(this.resultat);
                } else if (this.rang_entrer == 1 && this.rang_sortie == 4) {
                    this.resultat = valeur * 1000000.0;
                    DecimalFormat MyformatE = new DecimalFormat("0.000000E0");
                    this.str = MyformatE.format(this.resultat);
                } else if (this.rang_entrer == 2 && this.rang_sortie == 0) {
                    this.resultat = valeur * 2.778 * Math.pow(10.0, -4.0);
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 2 && this.rang_sortie == 1) {
                    this.resultat = valeur * 0.278;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 2 && this.rang_sortie == 2) {
                    this.resultat = valeur * 1.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 2 && this.rang_sortie == 3) {
                    this.resultat = valeur * 277.778;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 2 && this.rang_sortie == 4) {
                    this.resultat = valeur * 277777.778;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 3 && this.rang_sortie == 0) {
                    this.resultat = valeur * Math.pow(10.0, -6.0);
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 3 && this.rang_sortie == 1) {
                    this.resultat = valeur * 0.001;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 3 && this.rang_sortie == 2) {
                    this.resultat = valeur * 0.004;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 3 && this.rang_sortie == 3) {
                    this.resultat = valeur * 1.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 3 && this.rang_sortie == 4) {
                    this.resultat = valeur * 1000.0;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 4 && this.rang_sortie == 0) {
                    this.resultat = valeur * Math.pow(10.0, -9.0);
                    DecimalFormat MyformatE = new DecimalFormat("0.000000E0");
                    this.str = MyformatE.format(this.resultat);
                } else if (this.rang_entrer == 4 && this.rang_sortie == 1) {
                    this.resultat = valeur * Math.pow(10.0, -6.0);
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 4 && this.rang_sortie == 2) {
                    this.resultat = valeur * 3.6 * Math.pow(10.0, -6.0);
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 4 && this.rang_sortie == 3) {
                    this.resultat = valeur * 0.001;
                    this.str = Myformat.format(this.resultat);
                } else if (this.rang_entrer == 4 && this.rang_sortie == 4) {
                    this.resultat = valeur * 1.0;
                    this.str = Myformat.format(this.resultat);
                }
                this.sortie.setText(this.str);
            }
        }
        catch (NumberFormatException nfe) {
            this.entrer.setBackground(new Color(245, 77, 77));
            JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
            this.entrer.setBackground(new Color(255, 255, 255));
            this.entrer.requestFocus();
        }
    }
}

