/*
 * Decompiled with CFR 0.152.
 */
package mathgeo;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TriangleEquilateral
extends JDialog
implements ActionListener {
    private final String t = " ";
    private Double cote;
    private final JButton btncalculer;
    private final JButton btnreinitialiser;
    private final JTextField txtcote;
    private final JTextField txtaire;
    private final ImageIcon triequi;
    private final JLabel labimage;
    private final JLabel labcote;
    private final JLabel labaire;
    private final JLabel labdefinition;

    public TriangleEquilateral(JFrame proprio) {
        super(proprio, "Triangle Equilat\u00e9ral", false);
        this.setSize(820, 300);
        JPanel pan = new JPanel();
        pan.setBackground(new Color(215, 200, 170));
        this.setContentPane(pan);
        this.triequi = new ImageIcon(this.getClass().getResource("triangle_equilateral.jpg"));
        this.labimage = new JLabel(this.triequi);
        this.labimage.setBorder(BorderFactory.createLineBorder(new Color(59, 214, 242), 3));
        this.labcote = new JLabel("C");
        this.labcote.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtcote = new JTextField(9);
        this.btncalculer = new JButton("=");
        this.btncalculer.setFont(new Font("Comic Sans MS", 0, 15));
        this.labaire = new JLabel("Aire");
        this.labaire.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtaire = new JTextField(9);
        this.btnreinitialiser = new JButton("Reset");
        this.btnreinitialiser.setFont(new Font("Comic Sans MS", 0, 15));
        this.labdefinition = new JLabel("Pour chacun de ces polygones, le p\u00e9rim\u00e8tre est donn\u00e9 en multipliant la longueur d'un c\u00f4t\u00e9 par le nombre de c\u00f4t\u00e9s.");
        this.labdefinition.setFont(new Font("Comic Sans MS", 0, 15));
        this.btncalculer.addActionListener(this);
        this.btnreinitialiser.addActionListener(this);
        this.txtaire.setEditable(false);
        this.labdefinition.setForeground(new Color(49, 19, 5));
        Container contenu = this.getContentPane();
        contenu.setLayout(new FlowLayout());
        contenu.add(this.labimage);
        contenu.add(this.labcote);
        contenu.add(this.txtcote);
        contenu.add(this.btncalculer);
        contenu.add(this.labaire);
        contenu.add(this.txtaire);
        contenu.add(this.btnreinitialiser);
        contenu.add(this.labdefinition);
    }

    public void calculer() {
        try {
            char[] tab1 = this.txtcote.getText().toCharArray();
            boolean estUnNombre1 = true;
            for (int i = 0; i < tab1.length; ++i) {
                if (Character.isDigit(tab1[i]) || tab1[i] == '.' || tab1[i] == ' ') continue;
                estUnNombre1 = false;
            }
            if (estUnNombre1) {
                this.cote = Double.parseDouble(this.txtcote.getText());
                Double surface = this.cote * this.cote * Math.sqrt(3.0) / 4.0;
                NumberFormat Myformat = NumberFormat.getInstance();
                Myformat.setMinimumFractionDigits(3);
                Myformat.setMaximumFractionDigits(3);
                String str = Myformat.format(surface);
                this.txtaire.setText(str);
            } else if (!estUnNombre1) {
                this.txtcote.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
                this.txtcote.requestFocus();
                this.txtcote.setBackground(new Color(255, 255, 255));
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
            this.txtcote.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btncalculer) {
            this.calculer();
        }
        if (e.getSource() == this.btnreinitialiser) {
            this.txtcote.setText(" ");
            this.txtaire.setText(" ");
            this.txtcote.requestFocus();
        }
    }
}

