/*
 * Decompiled with CFR 0.152.
 */
package mathgeo;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Segment
extends JDialog
implements ActionListener {
    private final String t = " ";
    private Double rayonR;
    private Double angle;
    private final JButton btncalculer;
    private final JButton btnreinitialiser;
    private final JTextField txtrayon;
    private final JTextField txtangle;
    private final JTextField txtaire;
    private final ImageIcon segment;
    private final JLabel labimage;
    private final JLabel labrayon;
    private final JLabel labangle;
    private final JLabel labaire;
    private final JLabel labdefinition;
    private final JLabel labdefinition1;

    public Segment(JFrame proprio) {
        super(proprio, "Segment", false);
        this.setSize(890, 320);
        JPanel pan = new JPanel();
        pan.setBackground(new Color(215, 200, 170));
        this.setContentPane(pan);
        this.segment = new ImageIcon(this.getClass().getResource("segment.jpg"));
        this.labimage = new JLabel(this.segment);
        this.labimage.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 3));
        this.labrayon = new JLabel("R");
        this.labrayon.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtrayon = new JTextField(9);
        this.labangle = new JLabel("angle");
        this.labangle.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtangle = new JTextField(9);
        this.btncalculer = new JButton("=");
        this.btncalculer.setFont(new Font("Comic Sans MS", 0, 15));
        this.labaire = new JLabel("Aire");
        this.labaire.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtaire = new JTextField(9);
        this.btnreinitialiser = new JButton("Reset");
        this.btnreinitialiser.setFont(new Font("Comic Sans MS", 0, 15));
        this.labdefinition = new JLabel("La longueur d'un secteur angulaire vaut 2*PI*R*(n/360) o\u00f9 n est la valeur en degr\u00e9 de l'angle du secteur.");
        this.labdefinition.setFont(new Font("Comic Sans MS", 0, 15));
        this.labdefinition1 = new JLabel("Cas particulier : dans le cas du cercle, n = 360\u00b0 d'o\u00f9 une longueur de 2*PI*R. On rappelle que PI vaut environ 3,1415.");
        this.labdefinition1.setFont(new Font("Comic Sans MS", 0, 15));
        this.btncalculer.addActionListener(this);
        this.btnreinitialiser.addActionListener(this);
        this.txtaire.setEditable(false);
        Container contenu = this.getContentPane();
        contenu.setLayout(new FlowLayout());
        contenu.add(this.labimage);
        contenu.add(this.labrayon);
        contenu.add(this.txtrayon);
        contenu.add(this.labangle);
        contenu.add(this.txtangle);
        contenu.add(this.btncalculer);
        contenu.add(this.labaire);
        contenu.add(this.txtaire);
        contenu.add(this.btnreinitialiser);
        contenu.add(this.labdefinition);
        contenu.add(this.labdefinition1);
    }

    public void calculer() {
        try {
            char[] tab1 = this.txtrayon.getText().toCharArray();
            boolean estUnNombre1 = true;
            for (int i = 0; i < tab1.length; ++i) {
                if (Character.isDigit(tab1[i]) || tab1[i] == '.' || tab1[i] == ' ') continue;
                estUnNombre1 = false;
            }
            char[] tab2 = this.txtangle.getText().toCharArray();
            boolean estUnNombre2 = true;
            for (int i = 0; i < tab2.length; ++i) {
                if (Character.isDigit(tab2[i]) || tab2[i] == '.' || tab2[i] == ' ') continue;
                estUnNombre2 = false;
            }
            if (estUnNombre1 && estUnNombre2) {
                this.rayonR = Double.parseDouble(this.txtrayon.getText());
                this.angle = Double.parseDouble(this.txtangle.getText());
                Double surfacesecteur = Math.PI * this.rayonR * this.rayonR * this.angle / 360.0;
                Double surfacetriangle = 0.5 * this.rayonR * this.rayonR * Math.sin(Math.PI / 180 * this.angle);
                Double surface = surfacesecteur - surfacetriangle;
                NumberFormat Myformat = NumberFormat.getInstance();
                Myformat.setMinimumFractionDigits(3);
                Myformat.setMaximumFractionDigits(3);
                String str = Myformat.format(surface);
                this.txtaire.setText(str);
            } else if (!estUnNombre1 && !estUnNombre2) {
                this.txtrayon.setBackground(new Color(245, 77, 77));
                this.txtangle.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer des valeurs positives.");
                this.txtrayon.requestFocus();
                this.txtangle.setBackground(new Color(255, 255, 255));
                this.txtrayon.setBackground(new Color(255, 255, 255));
            } else if (!estUnNombre1) {
                this.txtrayon.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
                this.txtrayon.requestFocus();
                this.txtrayon.setBackground(new Color(255, 255, 255));
            } else if (!estUnNombre2) {
                this.txtangle.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
                this.txtangle.requestFocus();
                this.txtangle.setBackground(new Color(255, 255, 255));
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "Veuillez entrer des valeurs positives.");
            this.txtrayon.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btncalculer) {
            this.calculer();
        }
        if (e.getSource() == this.btnreinitialiser) {
            this.txtrayon.setText(" ");
            this.txtangle.setText(" ");
            this.txtaire.setText(" ");
            this.txtrayon.requestFocus();
        }
    }
}

