/*
 * Decompiled with CFR 0.152.
 */
package mathgeo;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PolygoneRegulier
extends JDialog
implements ActionListener {
    private final String t = " ";
    private Double cote;
    private Double nbcote;
    private final JButton btncalculer;
    private final JButton btnreinitialiser;
    private final JTextField txtcote;
    private final JTextField txtnbcote;
    private final JTextField txtaire;
    private final ImageIcon polygoneRegulier;
    private final JLabel labimage;
    private final JLabel labcote;
    private final JLabel labnbcote;
    private final JLabel labaire;
    private final JLabel labdefinition;
    private final JLabel labdefinition1;

    public PolygoneRegulier(JFrame proprio) {
        super(proprio, "Polygone r\u00e9gulier", false);
        this.setSize(674, 425);
        JPanel pan = new JPanel();
        pan.setBackground(new Color(215, 200, 170));
        this.setContentPane(pan);
        this.polygoneRegulier = new ImageIcon(this.getClass().getResource("polygoneregulier.png"));
        this.labimage = new JLabel(this.polygoneRegulier);
        this.labimage.setBorder(BorderFactory.createLineBorder(new Color(59, 214, 242), 3));
        this.labcote = new JLabel("c");
        this.labcote.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtcote = new JTextField(9);
        this.labnbcote = new JLabel("n");
        this.labnbcote.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtnbcote = new JTextField(9);
        this.btncalculer = new JButton("=");
        this.btncalculer.setFont(new Font("Comic Sans MS", 0, 15));
        this.labaire = new JLabel("Aire");
        this.labaire.setFont(new Font("Comic Sans MS", 0, 15));
        this.txtaire = new JTextField(9);
        this.btnreinitialiser = new JButton("Reset");
        this.btnreinitialiser.setFont(new Font("Comic Sans MS", 0, 15));
        this.labdefinition = new JLabel("Pour chacun de ces polygones, le p\u00e9rim\u00e8tre est donn\u00e9 en multipliant la longueur d'un c\u00f4t\u00e9");
        this.labdefinition.setFont(new Font("Comic Sans MS", 0, 15));
        this.labdefinition1 = new JLabel("par le nombre de c\u00f4t\u00e9s.");
        this.labdefinition1.setFont(new Font("Comic Sans MS", 0, 15));
        this.btncalculer.addActionListener(this);
        this.btnreinitialiser.addActionListener(this);
        this.txtaire.setEditable(false);
        this.labdefinition.setForeground(new Color(49, 19, 5));
        Container contenu = this.getContentPane();
        contenu.setLayout(new FlowLayout());
        contenu.add(this.labimage);
        contenu.add(this.labcote);
        contenu.add(this.txtcote);
        contenu.add(this.labnbcote);
        contenu.add(this.txtnbcote);
        contenu.add(this.btncalculer);
        contenu.add(this.labaire);
        contenu.add(this.txtaire);
        contenu.add(this.btnreinitialiser);
        contenu.add(this.labdefinition);
        contenu.add(this.labdefinition1);
    }

    public void calculer() {
        boolean calcul = true;
        try {
            char[] tab1 = this.txtcote.getText().toCharArray();
            boolean estUnNombre1 = true;
            for (int i = 0; i < tab1.length; ++i) {
                if (Character.isDigit(tab1[i]) || tab1[i] == '.' || tab1[i] == ' ') continue;
                estUnNombre1 = false;
            }
            char[] tab2 = this.txtnbcote.getText().toCharArray();
            boolean estUnNombre2 = true;
            for (int i = 0; i < tab2.length; ++i) {
                if (Character.isDigit(tab2[i]) || tab2[i] == ' ') continue;
                estUnNombre2 = false;
            }
            if (estUnNombre1 && estUnNombre2) {
                this.cote = Double.parseDouble(this.txtcote.getText());
                this.nbcote = Double.parseDouble(this.txtnbcote.getText());
                if (this.nbcote < 3.0) {
                    this.txtnbcote.setBackground(new Color(245, 77, 77));
                    JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur entiere de 3 ou sup\u00e9rieur pour n fois le c\u00f4t\u00e9.");
                    this.txtnbcote.setBackground(new Color(255, 255, 255));
                    calcul = false;
                }
                if (calcul) {
                    Double surface = this.nbcote * this.cote * this.cote / (4.0 * Math.tan(180.0 / this.nbcote * Math.PI / 180.0));
                    NumberFormat Myformat = NumberFormat.getInstance();
                    Myformat.setMinimumFractionDigits(3);
                    Myformat.setMaximumFractionDigits(3);
                    String str = Myformat.format(surface);
                    this.txtaire.setText(str);
                }
            } else if (!estUnNombre1 && !estUnNombre2) {
                this.txtcote.setBackground(new Color(245, 77, 77));
                this.txtnbcote.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer des valeurs positives et un entier pour n.");
                this.txtcote.requestFocus();
                this.txtnbcote.setBackground(new Color(255, 255, 255));
                this.txtcote.setBackground(new Color(255, 255, 255));
            } else if (!estUnNombre1) {
                this.txtcote.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer une valeur positive.");
                this.txtcote.requestFocus();
                this.txtcote.setBackground(new Color(255, 255, 255));
            } else if (!estUnNombre2) {
                this.txtnbcote.setBackground(new Color(245, 77, 77));
                JOptionPane.showMessageDialog(null, "Veuillez entrer un entier positif pour n.");
                this.txtnbcote.requestFocus();
                this.txtnbcote.setBackground(new Color(255, 255, 255));
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "Veuillez entrer des valeurs positives et un entier pour n.");
            this.txtcote.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btncalculer) {
            this.calculer();
        }
        if (e.getSource() == this.btnreinitialiser) {
            this.txtcote.setText(" ");
            this.txtnbcote.setText(" ");
            this.txtaire.setText(" ");
            this.txtcote.requestFocus();
        }
    }
}

