/**************************************************************  
    Autheur de ce programme : unité1994                      
    Date le 11/11/2017 - Avion atan(arctan)                   
    Programmation JavaScript dans IDE P5.js                                   

 ****************************************************************/

//  On définit toutes nos variables globales avant la fonction setup()                                                                                                                
//  Vitesse de l'avion
var speed_Aircraft; 

//  5 booleans qui prennent la valeur soit (true) ou (false) vrai où faut
//  pour touche clavière appuyée ou relâchée
var ri, le, up, dw, sp;   

//  Variables pour tir de munitions
//  Coordonnées cartésiennes avion ennemi
//  Coordonnées polaires mouvement munitions de l'avion ennemi
var x_tireur, y_tireur, x_cible, y_cible, theta, r = 0, vitesse;   
var x_bullet, y_bullet; 
var x_enemy = 0; y_enemy = 0;
//  Variable booléenne on = true
var on = true;


//  Fonction setup() appelée une seule fois au lancement du programme
function setup() {
  //  Taille de la fenêtre d'écran 600 par 800 pixels
  createCanvas(600, 800);

  //  PVector v1 pour coordonnées cartésiennes v1.x et v1.y de l'avion (vecteur 2d)
  v1 = createVector(width/2,  height/2 + 300);

  //  On charge nos images
  img_avion_mere      = loadImage("assets/avion_mere.png");
  img_mer             = loadImage("assets/fonds_mer.jpg");
  img_enemy           = loadImage("assets/avion.png");
  img_balle           = loadImage("assets/balle_fire.png");
  speed_Aircraft      = 3;  //  Vitesse avion mère
  x_enemy             = width/2;
}

//  Fonction draw() appelée sans arrêt jusqu'à la fin du programme
function draw() {

  // Affichage écran fonds mer
  image(img_mer, 0, 0);
  
  //  Centre le repère d'ancrage sur l'image
  imageMode(CENTER);
  //  Affiche l'image de l'avion ennemi aux coordonnées cartésiennes x_enemy, y_enemy
  image(img_enemy, x_enemy, y_enemy);
  //  Remets le mode imageMode par défaut
  //  le repère d'ancrage sur l'image est en haut à gauche
  imageMode(CORNER);
 
  //  Évolution de l'avion ennemi plus test de sortie d'écran
  //  L'avion ennemi se déplace sur l'ordonnée y_enemy par pas de 2 pixels vers le bas
  y_enemy += 2;
   //  Teste la sortie d'ecran de l'avion ennemi
  if(y_enemy > 850) y_enemy = -50;

  //  Appel de la fonction action_Aircraft()
  action_Aircraft();
  //  Appel de la fonction action_Enemy()
  action_Enemy();
  
  //  Centre le repère de l'ancrage sur l'image
  imageMode(CENTER);
  //  Affichage de l'image de l'avion aux coordonnées v1.x, v1.y
  image(img_avion_mere, v1.x, v1.y);
  textSize(18);
  //  Remets le mode imagetMode par défaut
  //  le repère d'ancrage sur l'image est en haut à gauche
  imageMode(CORNER);
  
  //  Affichage sur la fenêtre d'écran du vecteur v1 
  //  avec ses coordonnées catésiennes v1.x et v1.y en temps réel
  fill(255);  //  Couleur blanc
  text("PVector (avion mère) : " + "v1.x = " + v1.x + " v1.y = " + v1.y, 10, 25);
}

//  Fonction keyPressed()
//  Évènemment si on presse sur une touche sur le clavier
function keyPressed() {
  //  On teste la touche flèche droite si elle est appuyée
  if (keyCode == RIGHT_ARROW) {
    ri = true;
  } else
  //  On teste la touche flèche gauche si elle est appuyée
  if (keyCode == LEFT_ARROW) {
    le = true;
  } else
  //  On teste la touche flèche basse si elle est appuyée
  if (keyCode == DOWN_ARROW) {
    dw = true;
  }
  //  On teste la touche flèche haute si elle est appuyée
  if (keyCode == UP_ARROW) {
    up = true;
  }
}

//  Fonction keyReleased()
//  Évènemment si on relâche une touche du clavier 
function keyReleased() {
  //  On teste la touche flèche droite si elle est relâchée
  if (keyCode == RIGHT_ARROW) {
    ri = false;
  }
  //  On teste la touche flèche gauche si elle est relâchée
  else if (keyCode == LEFT_ARROW) {
    le = false;
  }
  //  On teste la touche flèche basse si elle est relâchée
  else if (keyCode == DOWN_ARROW) {
    dw = false;
  }
  //  On teste la touche flèche haute si elle est relâchée
  if (keyCode == UP_ARROW) {
    up = false;
  }

}

//  Fonction Action_Aircraft()  
function action_Aircraft() {
  //  On teste si le boolean ri égale à true  
  if (ri === true) {
    //  L'avion se déplace à droite de l'écran
    v1.x = v1.x + speed_Aircraft;
    //  On teste la sortie de l'avion à droite de l'écran
    if (v1.x > width - 30) v1.x = width - 30;
  }
  //  On teste si le boolean le égale à true  
  if (le === true) {
    //  L'avion se déplace à gauche de l'écran
    v1.x = v1.x - speed_Aircraft;
    //  On teste la sortie d'écran de l'avion à gauche  
    if (v1.x < 30) v1.x = 30;
  }
  //  On teste si le boolean dw égale à true  
  if (dw === true) {
    //  L'avion se déplace en bas de l'écran 
    v1.y = v1.y + speed_Aircraft;
    //  On teste la sortie de l'avion en bas de l'écran
    if (v1.y > height - 22) v1.y = height - 22;
  }
  //  On teste si le boolean up égale à true 
  if (up === true) {
    //  L'avion se déplace en haut de l'écran   
    v1.y = v1.y - speed_Aircraft;
    //  On teste la sortie de l'avion en haut de l'écran
    if (v1.y < 22) v1.y = 22;
  }
}

//  Fonction action_Enemy()  
function action_Enemy() {
  
  //  On rentre dans notre condition car la variable booléenne
  //  on = true on affecte plusieurs variables à la suite,
  //  sinon les calculs  
  //  de l'arc tangente et polaires ne peuvent pas se faire,
  //  on copie les coordonnées cartésiennes de l'avion ennemi,
  //  ici x_enemy et y_enemy aux variables x_tireur et y_tireur,
  //  on copie les coordonnées cartésiennes de l'avion mére,
  //  avec notre vecteur v1.x et v1.y aux variables x_cible et y_cible,
  //  cela nous servira quand on fera le calcul de l'arc tangent,
  //  pour retrouver l'angle entre l'avion mère et l'avion ennemi,
  //  cela nous servira pour le calcul des coordonnées polaires, 
  //  avec r pour le rayon qui évolue et qui dirigera les balles,
  //  de l'avion ennemi en visant l'avion mére,
  //  une fois affecter les variables, on ressort de la condition,
  //  avec on == false
  if(on) {
    x_tireur         = x_enemy;
    y_tireur         = y_enemy;   
    x_cible          = v1.x;
    y_cible          = v1.y; 
    r = 0;
    on = false;
   }
   
   if ( r===0 ) {
    if (x_cible >= x_tireur) {
      //  On calcule l'angle de tir avec l'arc tangent
      theta = atan((y_cible-y_tireur) / (x_cible-x_tireur));  
      //  On affecte une valeur tirée au hasard entre 2 et 5 à la variable vitesse
      vitesse = random(2, 5);
    } else
    {
      //  On calcule l'angle de tir avec l'arc tangent
      theta = atan((y_cible-y_tireur) / (x_cible-x_tireur));  
      //  On affecte une valeur négative tirée au hasard entre -2 et -5 à la variable vitesse
      vitesse  = -(random(2,5));
    }
  }
  
  //  Calcul des coordonnées polaires des balles de l'avion ennemi
  r += vitesse;
  x_bullet = cos(theta) * r + x_tireur;
  y_bullet = sin(theta) * r + y_tireur;
  
  //  On teste les sorties d'écran
  //  des coordonnées polaires x_bullet et y_bullet (balles de l'avion ennemi)
  if(x_bullet > width || x_bullet < 0 || y_bullet > height || y_bullet < 0) {
    on = true;
  }
  
  //  Affichage des balles de l'avion ennemi
  imageMode(CENTER);
  image(img_balle, x_bullet, y_bullet); 
  imageMode(CORNER);
}