/**************************************************************  
    Autheur de ce programme : himalaya2004                      
    Date le 07/11/2017 - PVector avion                                  
    Programmation JavaScript avec P5.js                                   

 ****************************************************************/

//  On définit toutes nos variables globales avant la fonction setup() 
//  Vitesse de l'avion
var speed_Aircraft;             

//  5 booleans à (true) ou (false) vrai où faut
//  pour les touches du clavier appuyée ou relâchée
var ri, le, up, dw;     

//  Fonction setup() appelée une seule fois au lancement du programme
function setup() {
  //  Taille de la fenêtre d'écran 600 par 800 pixels
  createCanvas(600, 800);

  //  PVector v1 pour coordonnées cartésiennes v1.x et v1.y de l'avion (vecteur 2d)
  v1 = createVector(width/2,  height/2 + 300);

  //  On charge nos images 
  img_avion           = loadImage("assets/avion_mere.png");
  img_mer             = loadImage("assets/fonds_mer.jpg");
  speed_Aircraft      = 3;  //  Vitesse avion mère
}

//  Fonction draw() appelée sans arrêt jusqu'à la fin du programme
function draw() {

  // Affichage écran fonds mer
  image(img_mer, 0, 0);

  //  Appel de fonction action_Aircraft()
  action_Aircraft();
  
  //  Centre le repère d'ancrage sur l'image
  imageMode(CENTER);
  //  Affiche l'image de l'avion aux coordonnées v1.x, v1.y
  image(img_avion, v1.x, v1.y);
  //  Remets le mode imagetMode par défaut
  //  le repère d'ancrage sur l'image est en haut à gauche
  imageMode(CORNER);
  
  //  Affichage sur la fenêtre d'écran du vecteur v1 
  //  avec ses coordonnées catésiennes v1.x et v1.y en temps réel
  fill(255);  //  couleur blanc
  textSize(18);
  text("PVector (avion mère) : " + "v1.x = " + v1.x + " v1.y = " + v1.y, 10, 25);
}

//  Fonction keyPressed()
//  Évènemment si on presse sur une touche sur le clavier
function keyPressed() {
  //  On teste la touche flèche droite si elle est appuyée
  if (keyCode == RIGHT_ARROW) {
    ri = true;
  } else
  //  On teste la touche flèche gauche si elle est appuyée
  if (keyCode == LEFT_ARROW) {
    le = true;
  } else
  //  On teste la touche flèche basse si elle est appuyée
  if (keyCode == DOWN_ARROW) {
    dw = true;
  }
  //  On teste la touche flèche haute si elle est appuyée
  if (keyCode == UP_ARROW) {
    up = true;
  }
}

//  Fonction keyReleased()
//  Évènemment si on relâche une touche du clavier 
function keyReleased() {
  //  On teste la touche flèche droite si elle est relâchée
  if (keyCode == RIGHT_ARROW) {
    ri = false;
  }
  //  On teste la touche flèche gauche si elle est relâchée
  else if (keyCode == LEFT_ARROW) {
    le = false;
  }
  //  On teste la touche flèche basse si elle est relâchée
  else if (keyCode == DOWN_ARROW) {
    dw = false;
  }
  //  On teste la touche flèche haute si elle est relâchée
  if (keyCode == UP_ARROW) {
    up = false;
  }

}

//  Fonction Action_Aircraft()  
function action_Aircraft() {

  //  On teste si le boolean ri égale à true 
  if (ri === true) {
    //  L'avion se déplace à droite de l'écran
    v1.x = v1.x + speed_Aircraft;
    //  On teste la sortie de l'avion à droite de l'écran
    if (v1.x > width - 30) v1.x = width - 30;
  }
  //  On teste si le boolean le égale à true  
  if (le === true) {
    //  L'avion se déplace à gauche de l'écran
    v1.x = v1.x - speed_Aircraft;
    //  On teste la sortie d'écran de l'avion à gauche  
    if (v1.x < 30) v1.x = 30;
  }
  //  On teste si le boolean dw égale à true  
  if (dw === true) {
    //  L'avion se déplace en bas de l'écran 
    v1.y = v1.y + speed_Aircraft;
    //  On teste la sortie de l'avion en bas de l'écran
    if (v1.y > height - 22) v1.y = height - 22;
  }
  //  On teste si le boolean up égale à true 
  if (up === true) {
    //  L'avion se déplace en haut de l'écran   
    v1.y = v1.y - speed_Aircraft;
    //  On teste la sortie de l'avion en haut de l'écran
    if (v1.y < 22) v1.y = 22;
  }
}