/***********************************
 **  class Aircraft 
 **  affichage et mouvement
 **  de l'Aircraft
 **********************************/

 function Aircraft(x, y) {
  this.x = v1.x;
  this.y = v1.y;

  //  Méthode display
  //  affichage Aircraft
  this.display = function() {
    if (!toucher) {
      imageMode(CENTER);
      image(img_avion_mere, v1.x, v1.y);
      imageMode(CORNER);
    }
  }

  //  Méthode reaffiche_aircraft
  //  on reaffiche l'aircraft
  //  après collision
  this.reaffiche_Aircraft = function() {
    if (toucher) {
        v1.x = v1.x;
        v1.y = v1.y;
        toucher = false;
      }
    }
    //  Méthode move_Aircraft_D_G 
    //  Mouvement à droite ou à gauche de l'Aircraft
    this.move_Aircraft_D_G = function(facteur_direction) {
      v1.x = v1.x + facteur_direction * speed_Aircraft;
      if (v1.x < 29) v1.x = 29;
      else if (v1.x > width - 29) v1.x = width - 29;
    }
    //  Méthode move_Aircraft_H_B
    //  Mouvement en haut ou en bas de l'Aircraft
    this.move_Aircraft_H_B = function(facteur_direction) {
      v1.y = v1.y + facteur_direction * speed_Aircraft;
      if (v1.y < 71) v1.y = 71;
      else if (v1.y > height - 23) v1.y = height - 23;
    }
    //  Méthode collision
    //  Collision Aircraft avec enemy
    this.collision = function() {
      if (!invincible) {
        for (var l = 0; l < enemy.length; l++) {
          if (v1.x - round(enemy[l].x + enemy[l].coord_x) <= 28 &&
          v1.x - round(enemy[l].x + enemy[l].coord_x) >= -28 &&
          v1.y - round(enemy[l].y + enemy[l].coord_y) <= 28 &&
          v1.y - round(enemy[l].y + enemy[l].coord_y) >= -28) {
          //  Animation feu enemy
          x_anim_aircraft = v1.x;
          y_anim_aircraft = v1.y;
          i_anim_aircraft = 0;
          nb_frames_anim_aircraft = millis();
          anim_feu_aircraft = true;

          explosion.play();

          vies -= 1;
          if (vies < 0) {
            vies = 0;
            game_over = false;
          }

          //  Bouclier et réaffiche bouclier plus tempo
          display_aircraft = true;
          display_tir = false;
          toucher = true;
          mem_display_reaffichage = millis();
          time_bouclier = 4000;
          aircraft.reaffiche_Aircraft();
          mem_bouclier = millis();
          invincible = true;

          enemy.splice(l, 1);
          if (enemy.length === 0) {
            launch_vague = true;
            nb_vague++;
          }
          if (nb_vague == tab_vagues.length) {
            //  Fin du niveau des vagues successifs
            nb_vague = 0;
            //  Tirage shuffle tab_vagues
            shuffle(tab_vagues, true);  
          }
        }
      }
    }
  }
}